#include "../scorpion.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../Generator.h"

#define FOND_Z (1.f)

static GrVertex Fond1 = {450.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {550.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {550.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {450,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static GrVertex Fond5 = {0.f,337.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond6 = {640.f,337,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond7 = {640.,412.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond8 = {0,412.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static float Matrix[16];
static float Matrix2[16];
static float GouraudMatrix[16];
static float GouraudMatrix2[16];

static Obj3d* pTorus;

void LInit_Tunnel3d3()
{
	pTorus = GenerateTorus(90, 20, 500, 50);
	LoadJpegTexture( bigrid3, &g_TextureBigrid);
	//ComputeGouraud(pTorus);
}

void QInit_Tunnel3d3()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_FACTOR_NONE, GR_COMBINE_OTHER_NONE, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grAlphaTestFunction(GR_CMP_ALWAYS);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_POSITIVE);

	//grFogMode(GR_FOG_WITH_TABLE);
	grFogMode(GR_FOG_DISABLE);
	grFogColorValue(0x33aa33);
	grFogTable(g_FogTunnel);

	SelectTexture(g_TextureBigrid);

	grConstantColorValue(128<<24);
	g_demostate.ClearColor = 0;
}


void Effect_Tunnel3d3()
{
	int Img1 = 0;
	FxU32 Nega = 0;
	static float TTT = 0;

	Img1 = g_demostate.TickInEffect/16;

	Nega = ((g_demostate.TickInEffect>>11)&1)&((g_demostate.TickInEffect>>6)&1);
	Nega = 0;

	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, Nega);

	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix,500*sin(Img1/120.f),0,500*cos(Img1/120.f));
	RotateXMatrix(Matrix2, Matrix, Img1/70.f);
	RotateYMatrix(Matrix, Matrix2, Img1/70.f);
	RotateZMatrix(Matrix2, Matrix, Img1/70.f);

	BeIdentityMatrix(GouraudMatrix);
	RotateXMatrix(GouraudMatrix2, GouraudMatrix, Img1/90.f);
	RotateYMatrix(GouraudMatrix, GouraudMatrix2, Img1/90.f);
	RotateZMatrix(GouraudMatrix2, GouraudMatrix, Img1/90.f);

	BeIdentityMatrix(Matrix2);
	TranslateMatrix(Matrix2, 100., 100., 100.);

	DrawWithMatrix(pTorus, Matrix2, 0, GouraudMatrix2);

	/*grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_SRC_ALPHA, GR_BLEND_ONE_MINUS_SRC_ALPHA,
							GR_BLEND_ONE, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_NONE, Nega);

	grDrawTriangle(&Fond1, &Fond3, &Fond2);
	grDrawTriangle(&Fond3, &Fond1, &Fond4);

	grDrawTriangle(&Fond5, &Fond7, &Fond6);
	grDrawTriangle(&Fond7, &Fond5, &Fond8);*/

}

void ByeBye_Tunnel3d3()
{

}
